---
Difficulty: Easy  
Source: Daily-Question (POTD 12-Dec)  
Tags: 
- Array
- Heap (Priority Queue)
- Simulation
---

# 🚀 *2558 - Take Gifts From the Richest Pile* 🧠

### Problem Link:
[**LeetCode - Take Gifts From the Richest Pile**](https://leetcode.com/problems/take-gifts-from-the-richest-pile/description/?envType=daily-question&envId=2024-12-12)

## 💡 **Problem Breakdown:**

You are given an integer array `gifts` denoting the number of gifts in various piles. Every second, you perform the following operation:

1. Choose the pile with the maximum number of gifts.
2. If there are multiple piles with the maximum number of gifts, choose any.
3. Leave behind the floor of the square root of the number of gifts in the pile. Take the rest of the gifts.

You need to return the total number of gifts remaining after performing the above operation `k` times.

## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`gifts = [25, 64, 9, 4, 100], k = 4`  

**Output:**  
`29`

**Explanation:**  
The gifts are taken in the following way:
- In the first second, the pile with 100 gifts is chosen and 10 gifts (floor of sqrt(100)) are left behind. The pile becomes 10 gifts.
- Then the pile with 64 gifts is chosen and 8 gifts (floor of sqrt(64)) are left behind. The pile becomes 8 gifts.
- After that, the pile with 25 gifts is chosen and 5 gifts (floor of sqrt(25)) are left behind. The pile becomes 5 gifts.
- Finally, the pile with 10 gifts is chosen again, and 3 gifts (floor of sqrt(10)) are left behind. The pile becomes 3 gifts.

The final remaining gifts are: `[5, 8, 9, 4, 3]`, so the total remaining gifts are `5 + 8 + 9 + 4 + 3 = 29`.

### Example 2:

**Input:**  
`gifts = [1, 1, 1, 1], k = 4`  

**Output:**  
`4`

**Explanation:**  
In this case, regardless of which pile you choose, you will always leave behind 1 gift (since the square root of 1 is 1). Therefore, no gifts can be taken from the piles, and the total gifts remaining are `1 + 1 + 1 + 1 = 4`.

## 🎯 **My Approach:**

We can approach this problem using a **greedy strategy** with a **max heap** (priority queue). The steps are:

1. **Max-Heap for Efficient Selection:**  
   Since we need to repeatedly select the pile with the maximum number of gifts, a max-heap is suitable as it allows us to efficiently retrieve and update the pile with the most gifts.
   
2. **Heap Operations:**  
   For each second, pop the largest pile from the heap, compute the floor of the square root of the number of gifts in that pile, and then push the new value back into the heap.
   
3. **Stop After `k` Iterations:**  
   After performing the operation `k` times, sum up the remaining gifts in the heap to get the final result.

## 🕒 **Time Complexity:**

- **O(k * log n):**  
  Each heap operation (pop and push) takes `O(log n)` time, where `n` is the number of piles (i.e., the length of the `gifts` array). Since we perform the operation `k` times, the overall time complexity is `O(k * log n)`.

- **Space Complexity:**  
  **O(n):** The space complexity is determined by the heap, which stores at most `n` piles.

## 📝 **Solution Code**

## Code (C):

```c
long long pickGifts(int* gifts, int giftsSize, int k) {
    for (int i = (giftsSize - 2) / 2; i >= 0; i--) {
        int current = i;
        while (current * 2 + 1 < giftsSize) {
            int child = current * 2 + 1;
            if (child + 1 < giftsSize && gifts[child] < gifts[child + 1]) {
                child++;
            }
            if (gifts[current] >= gifts[child]) {
                break;
            }
            int temp = gifts[current];
            gifts[current] = gifts[child];
            gifts[child] = temp;
            current = child;
        }
    }

    for (int i = 0; i < k; i++) {
        gifts[0] = (int)sqrt(gifts[0]);
        int current = 0;
        while (current * 2 + 1 < giftsSize) {
            int child = current * 2 + 1;
            if (child + 1 < giftsSize && gifts[child] < gifts[child + 1]) {
                child++;
            }
            if (gifts[current] >= gifts[child]) {
                break;
            }
            int temp = gifts[current];
            gifts[current] = gifts[child];
            gifts[child] = temp;
            current = child;
        }
    }

    long long sum = 0;
    for (int i = 0; i < giftsSize; i++) {
        sum += gifts[i];
    }
    return sum;
}
```

## Code (C++)

```cpp
class Solution {
public:
    long long pickGifts(std::vector<int>& gifts, int k) {
        std::priority_queue<int> maxHeap(gifts.begin(), gifts.end());
        for (int i = 0; i < k; ++i) {
            int top = maxHeap.top();
            maxHeap.pop();
            maxHeap.push((int)sqrt(top));
        }
        
        long long total = 0;
        while (!maxHeap.empty()) {
            total += maxHeap.top();
            maxHeap.pop();
        }
        return total;
    }
};
```

## Code (Java)

```java
class Solution {
    public long pickGifts(int[] gifts, int k) {
        PriorityQueue<Integer> maxHeap = new PriorityQueue<>((a, b) -> b - a);
        for (int gift : gifts) {
            maxHeap.offer(gift);
        }
        
        for (int i = 0; i < k; i++) {
            int top = maxHeap.poll();
            maxHeap.offer((int)Math.sqrt(top));
        }
        
        long total = 0;
        while (!maxHeap.isEmpty()) {
            total += maxHeap.poll();
        }
        return total;
    }
}
```

## Code (Python)

```python
class Solution:
    def pickGifts(self, gifts: List[int], z: int) -> int:
        h = [-v for v in gifts]
        heapify(h)
        for _ in range(z):
            heapreplace(h, -int(sqrt(-h[0])))
        return -sum(h)
```

## Code (Rust)

```rust
use std::collections::BinaryHeap;

impl Solution {
    pub fn pick_gifts(gifts: Vec<i32>, k: i32) -> i64 {
        let mut max_heap: BinaryHeap<i32> = BinaryHeap::from(gifts);
        for _ in 0..k {
            if let Some(top) = max_heap.pop() {
                max_heap.push((top as f64).sqrt() as i32);
            }
        }
        max_heap.into_iter().map(|x| x as i64).sum()
    }
}
```

## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
